packer {
  required_version = ">=1.7.0"
  required_plugins {
    docker = {
      source  = "github.com/hashicorp/docker"
      version = ">=0.0.7"
    }
    puppet = {
      source  = "github.com/hashicorp/puppet"
      version = ">=1.0.0"
    }
  }
}

variable "manifest_path" {
  type    = string
  default = "manifests"
}

source "docker" "autogenerated_1" {
  discard = true
  image   = "ubuntu:latest"
}

build {

  sources = ["source.docker.autogenerated_1"]

  provisioner "shell" {
    inline = [
      "apt-get update",
      "apt-get -qq -y install wget sudo",
      "wget https://apt.puppetlabs.com/puppet6-release-focal.deb",
      "sudo dpkg -i puppet6-release-focal.deb",
      "apt-get update",
      "apt-get -qq -y install puppet-agent"
    ]
  }

  provisioner "puppet-masterless" {
    puppet_bin_dir = "/opt/puppetlabs/bin/"
    manifest_file  = var.manifest_path
  }
}
